// author: RuanShengQiang 
// date: 2017/6/1
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

float _abs(float a)
{
	if(a<0.0f)
		return -a;
	else
		return a;
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	//const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;

	
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float curPos = progress*2.0f;
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 UV = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	
	float Radius = 1.0f;

	float T = progress;

	//vec2 UV = gl_FragCoord.xy / resolution.xy;

	UV -= (vec2)( 0.5f, 0.5f);

	float Dist = length(UV);

	if ( Dist < Radius )
	{
		float Percent = (Radius - Dist) / Radius;
		float A = ( T <= 0.5f ) ? mix( 0.0f, 1.0f, T/0.5f ) : mix( 1.0f, 0.0f, (T-0.5f)/0.5f );
		float Theta = Percent * Percent * A * 8.0f * 3.14159f;
		float S = sin( Theta );
		float C = cos( Theta );
		UV = (vec2)( dot(UV, (vec2)(C, -S)), dot(UV, (vec2)(S, C)) );
	}
	UV += (vec2)( 0.5f, 0.5f);

	vec4 C0 = INPUT(input1, param, UV );
	vec4 C1 = INPUT(input2, param, UV );
	write_imagef(dstImg, (int2)(w, textH - h -1), mix( C0, C1, T ));
}